package agentes;


import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.TickerBehaviour;
import jade.core.behaviours.WakerBehaviour;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;



public class MadreAgent extends Agent{
	protected void setup() {
		final ACLMessage mensajeDeRico=blockingReceive();
		String message = mensajeDeRico.toString();
    	System.out.println(getLocalName() + ": acaba de recibir el siguiente mensaje: ");
        System.out.println(message);
        String messageContent= mensajeDeRico.getContent();        
	   
        SequentialBehaviour seq= new SequentialBehaviour();
	    // Add the TickerBehaviour (period 1 sec)
	    seq.addSubBehaviour(new TickerBehaviour(this, 1000) {
	      protected void onTick() {
	    	  int i=getTickCount();
	        System.out.println("Han pasado "+getTickCount()+ " segundos desde que " +mensajeDeRico.getSender().getName()+ "ha llegado a la cumbre");
	        if(i==30){
	        	
	        	stop();
	        }
	      } 
	    });
	    
	    

	    // Add the WakerBehaviour (wakeup-time 1 secs)
	    seq.addSubBehaviour(new WakerBehaviour(this, 1000) {
	      protected void onWake() {
	        System.out.println("Se ha terminado todo.");
	        myAgent.doDelete();
	      } 
	    });
	    addBehaviour(seq);	  } 
}
