package tarea;
import jade.core.Agent;
import jade.core.behaviours.*; 

import java.util.*;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

public class Comprador extends Agent{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	//dinero inicial del drogadicto
	private int dinero = 0 ;
	//Drogadicto de verdad o no(0: drogadicto /1:polica infiltrado)
	public int e = 0;

	public int getE() 
	{ 
		return e;
	}  

	// Crear aleatoriamente el tipo de comprador ( drogadicto / polica infiltrado )
	protected void tipoComprador()
	{
		Random randomGenerator =new Random();
		e = randomGenerator.nextInt(2);
	}
	
	// Asignar dinero al comprador
	protected void dineroInicial()
	{
		//si es un poli infiltrado tendr dinero
		if (e == 1){
			dinero = 200;
		}else{ //si es un drogadicto corriente, depende
			Random randomGenerator = new Random();    
			dinero = randomGenerator.nextInt(200);
		}
	}
	
	protected void setup()
	{
		// Lista con los compradores
		DFAgentDescription listadoCompradores = new DFAgentDescription();
		listadoCompradores.setName( getAID() );
		ServiceDescription sd = new ServiceDescription();
		sd.setType("tipo-drogadicto");
		sd.setName( getLocalName() );
		listadoCompradores.addServices(sd);
		try 
		{
		  DFService.register(this, listadoCompradores);
		}
		catch (FIPAException err) 
		{
		  err.printStackTrace();
		}
		
//		getE();
		tipoComprador();
		dineroInicial();
		System.out.println("---------------------------------------------------------------------------------");
		System.out.println("[Agente Comprador " + getLocalName() + "] ha entrado al callejon, y tiene " + dinero + ".");
		if (e == 1){ // es poli
			System.out.println("Y [" + getLocalName() + "] es un poli infiltrado... shhhh");
		}
		System.out.println("---------------------------------------------------------------------------------");
		
		// Aadir behaviours
		addBehaviour(new Escuchar());
		addBehaviour(new Comprar());
	}
	
	private class Escuchar extends CyclicBehaviour 
	{
	  /**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	public void action()
	  {
		  MessageTemplate mt = MessageTemplate.MatchPerformative( ACLMessage.CFP );
		  ACLMessage msg = myAgent.receive( mt );
		  
			if (msg != null)
			{
				if ( msg.getSender().getLocalName().equals("Loco"))
				{
					doDelete();
				}				
				else
				{
				  // Se ha recibido un mensaje y lo procesamos
				  ACLMessage reply = msg.createReply();
				  
				  System.out.println("---------------------------------------------------------------------------------");
				  System.out.println("["+getLocalName() +"]: Este yonki me quiere vender...");
				  System.out.println(getLocalName() + " piensa y...");
				  System.out.println("---------------------------------------------------------------------------------\n");
				  doWait(100);
				  if (e == 1) // si soy poli
				  {
					 reply.setPerformative(ACLMessage.PROPOSE);
					 System.out.println("["+ getLocalName() +"]: S, quiero ese producto tuyo.");
				  }else{				  
					  if (dinero > 50) // si tengo dinero suficiente
					  {
						  reply.setPerformative(ACLMessage.PROPOSE);
						  System.out.println("["+ getLocalName() +"]: S, quiero ese producto tuyo.");
					  }
					  else
					  {// no tengo dinero
						  reply.setPerformative( ACLMessage.REFUSE );
						  System.out.println("["+getLocalName() +"]: Estoy con poco money... Solo tengo " + dinero + ".");
						  System.out.println("["+getLocalName() +"]: Bueno mejor me voy...\n" );
					  }
				  }
				
				 doWait(5000);
				 myAgent.send(reply);
			  }
			}
			else 
			{
				block();
			}
		}
	  
	}
	
	private class Comprar extends CyclicBehaviour
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public void action() {
			MessageTemplate mt = MessageTemplate.MatchPerformative(ACLMessage.ACCEPT_PROPOSAL);
			ACLMessage mensaje = myAgent.receive(mt);
			if (mensaje != null)
			{
				ACLMessage reply = mensaje.createReply();

				if ( e == 1 ) //arrestar
				{
					reply.setPerformative( ACLMessage.FAILURE );
					System.out.println("\n["+getLocalName() +"]: Queda usted [" + mensaje.getSender().getLocalName() + "] detenido. Tiene derecho a permanecer en silencio. Cualquier cosa que diga podr ser usada en su contra ante un tribunal. Tiene derecho a consultar a un abogado y/o a tener a uno presente cuando sea interrogado por la polica. Si no puede contratar a un abogado, le ser designado uno para representarlo");
				}
				else
				{
					// aceptar comprar
					reply.setPerformative( ACLMessage.INFORM );
					dinero=dinero-50;
					System.out.println("["+getLocalName() +"]: Eso es, esto va a ser la hostia! Y todava tengo " + dinero + ".");
					System.out.println("---------------------------------------------------------------------------------");
					System.out.println("["+ getLocalName() +"] se va a su garito a disfrutar del producto.");
					System.out.println("---------------------------------------------------------------------------------\n");
				}
				doWait(5000);
			    myAgent.send(reply);
			}else{
			    block();
			}
		}
	}
	
	protected void takeDown()
	{
		try 
		{
			DFService.deregister(this);
		}
		catch (FIPAException err) 
		{
			err.printStackTrace();
		}
		doWait(5000);
		System.out.println("---------------------------------------------------------------------------------");
		System.out.println( getLocalName() + " se va a su garito." );
		System.out.println("---------------------------------------------------------------------------------\n");
	}
	
}
