package tarea;
import jade.core.Agent;
import jade.core.behaviours.*; 
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

	public class Mendigo extends Agent
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		int i=0;

		protected void setup() 
		{
			System.out.println("---------------------------------------------------------------------------------");
			System.out.println("[Agente Mendigo " + getLocalName() + "] est sentado en una esquina de la calle.");
			System.out.println("---------------------------------------------------------------------------------\n");
			
			// Lista de mendigos
			DFAgentDescription listadoVagabundos = new DFAgentDescription();
			listadoVagabundos.setName( getAID() );
			ServiceDescription sd2 = new ServiceDescription();
			sd2.setType("tipo-vagabundo");
			sd2.setName( getLocalName() );
			listadoVagabundos.addServices(sd2);
			try 
			{
			  DFService.register(this, listadoVagabundos);
			}
			catch (FIPAException err) 
			{
			  err.printStackTrace();
			}
				
			//Esperando un mensaje para desbloquear
			final ACLMessage msg = blockingReceive(MessageTemplate.MatchPerformative(ACLMessage.REQUEST));
			
			//Se nos acerca un agente comprador
			SequentialBehaviour secuencia = new SequentialBehaviour();
			secuencia.addSubBehaviour(new WakerBehaviour(this, 5000) 
			{
				/**
				 * 
				 */
				private static final long serialVersionUID = 1L;

				protected void onWake() 
				{
					System.out.println("---------------------------------------------------------------------------------");
					System.out.println(getLocalName()+" se fija que le saludan.");
					System.out.println("---------------------------------------------------------------------------------\n");
				} 
			});
			
			secuencia.addSubBehaviour	
			(new WakerBehaviour(this, 1000) 
			{
				/**
				 * 
				 */
				private static final long serialVersionUID = 1L;

				protected void onWake() 
				{
					// Devolvemos el saludo al vendedor
					System.out.println("["+getLocalName()+"]: Hola chico.");
					
					ACLMessage reply = new ACLMessage(ACLMessage.FAILURE);
					reply.addReceiver(msg.getSender());
					reply.setContent("saludo");
					send(reply);
					
					doDelete();
				} 
			});
			addBehaviour( secuencia );
		}
		
		protected void takeDown()
		{
		 	try 
			{
				DFService.deregister(this);
			}
			catch (FIPAException err) 
			{
				err.printStackTrace();
			}
			System.out.println("---------------------------------------------------------------------------------");
			System.out.println("["+getLocalName()+"]: pues yo me voy a echar una siesta.");
			System.out.println("---------------------------------------------------------------------------------\n");
		}
	}
