package tarea;
import jade.core.Agent;
import jade.core.AID;
import jade.core.behaviours.*; 

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

public class Vendedor extends Agent{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private AID[] listaDrogadictos;
	private AID[] listaVagabundos;
	
	protected void setup()
	{
		System.out.println("---------------------------------------------------------------------------------");
		System.out.println("[Agente Vendedor " + getLocalName() + "] ha llegado a la calle dispuesto a vender.");
		System.out.println("---------------------------------------------------------------------------------\n");
		System.out.println("[" + getLocalName() + "]: Ya est el loco de siempre merodeando por aqu...\n");
		
		/** Aadir behaviours **/
		addBehaviour
			(new WakerBehaviour(this, 5000) 
			{
				/**
				 * 
				 */
				private static final long serialVersionUID = 1L;

				protected void onWake() 
				{
					System.out.println("---------------------------------------------------------------------------------");
					System.out.println("Mientras " + getLocalName() + " fuma, observa lo que se mueve por la calle.");
					System.out.println("---------------------------------------------------------------------------------\n");

					// Vamos a saludar al primer mendigo que encontremos
					addBehaviour( new SaludarMendigo() );
				} 
			}
		);
	}
	private class SaludarMendigo extends OneShotBehaviour 
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public void action()
		{
			  //Lista de vagabundos
			  DFAgentDescription template2 = new DFAgentDescription();
			  ServiceDescription sd2 = new ServiceDescription();
			  sd2.setType("tipo-vagabundo");
			  template2.addServices(sd2);
			  int i=0;
			  try 
			  {
				DFAgentDescription[] result = DFService.search(myAgent, template2);
				System.out.println("---------------------------------------------------------------------------------");
				System.out.println("[" + getLocalName() + "]: He encontrado los siguientes mendigos:");
				listaVagabundos = new AID[result.length];
				for (i = 0; i < result.length; i++)
				{
					listaVagabundos[i] = result[i].getName();
					System.out.println(listaVagabundos[i].getLocalName());
				}
				System.out.println("---------------------------------------------------------------------------------\n");
			  }
			  catch (FIPAException err)
			  {
				err.printStackTrace();
			  }
			  // Si hay algun mendigo
			  if ( listaVagabundos.length > 0 )
				{				
						ACLMessage hola = new ACLMessage( ACLMessage.REQUEST );
						
						hola.addReceiver( listaVagabundos[0] );
						hola.setContent( "hola" );
						hola.setConversationId("hola");
						hola.setReplyWith("hola"+System.currentTimeMillis());
						myAgent.send( hola );	
				}
			  // Saludar al primer mendigo encontrado
			  DFAgentDescription template3 = new DFAgentDescription();
				ServiceDescription sd3 = new ServiceDescription();
				sd3.setType("tipo-vagabundo");
				template3.addServices(sd3);
					
				try 
				{
					DFAgentDescription[] result2 = DFService.search(myAgent, template3); 					
					listaVagabundos = new AID[result2.length];
					System.out.println("["+ getLocalName() +"]: Buenos das mendigo!\n");
					
				}
				catch (FIPAException err)
				{
					err.printStackTrace();
				} 			  
			  
			 doWait(10000);
			 // Pasamos a buscar compradores para venderles
			 addBehaviour( new BuscarCompradores() );
		}
	}
	
	private class BuscarCompradores extends OneShotBehaviour 
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;


		public void onStart()
		{
			System.out.println("---------------------------------------------------------------------------------");
			System.out.println("[" + getLocalName() + "]: Hoy me saco un dinerito...");
			System.out.println("---------------------------------------------------------------------------------\n");		
		}
		
	
		public void action()
		{
			  //Lista de compradores
			  DFAgentDescription template = new DFAgentDescription();
			  ServiceDescription sd = new ServiceDescription();
			  sd.setType("tipo-drogadicto");
			  template.addServices(sd);
			  int i=0;
			  try 
			  {
				DFAgentDescription[] result = DFService.search(myAgent, template);
				System.out.println("---------------------------------------------------------------------------------");
				System.out.println("[" + getLocalName() + "]: He encontrado los siguientes drogadictos:");
				listaDrogadictos = new AID[result.length];
				for (i = 0; i < result.length; i++)
				{
					listaDrogadictos[i] = result[i].getName();
					System.out.println(listaDrogadictos[i].getLocalName());
				}
				System.out.println("---------------------------------------------------------------------------------\n");
			  }
			  catch (FIPAException err)
			  {
				err.printStackTrace();
			  }
			  
			 doWait(10000);
			 // Vamos a intentar vender
			 addBehaviour( new Vender() );
		}
	}
	    
	private class Vender extends Behaviour
	{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public int onEnd()
		{
			return 0;
		}
		private MessageTemplate tratarRespuestas;
		private int step = 0 ;
		private int i = 0 ;
	
		public void action()
		{
		    switch (step) 
			{
			case 0:	 // va a donde un comprador						
				ACLMessage cfp = new ACLMessage(ACLMessage.CFP);
			
				System.out.println("---------------------------------------------------------------------------------");
				System.out.println("[" + getLocalName() +"]: Voy a por [" + listaDrogadictos[i].getLocalName() +"], a ver si me compra...");
				System.out.println("---------------------------------------------------------------------------------\n");
				cfp.addReceiver(listaDrogadictos[i]);
			 
				cfp.setConversationId("comercial");
				cfp.setReplyWith("cfp"+System.currentTimeMillis()); 
				myAgent.send(cfp);
			
				System.out.println("[" + getLocalName() +"]--->[" + listaDrogadictos[i].getLocalName() +"]\n");
				System.out.println("["+ getLocalName() +"]: Hola amigo! Quieres probar mi producto? Es cristal con pureza del 98%.\n");
			
				tratarRespuestas = MessageTemplate.and( MessageTemplate.MatchConversationId("comercial")
								  ,MessageTemplate.MatchInReplyTo( cfp.getReplyWith() ) );
				step=1;
				break;
				
			case 1: // me responde el comprador y analizo la respuesta			
				ACLMessage respuesta = myAgent.receive( tratarRespuestas );
												
				if (respuesta != null) 
				{
		
				// nos acepta y quiere comprar
					if ( respuesta.getPerformative() == ACLMessage.PROPOSE ) 
					{
						System.out.println("\n[" + getLocalName() +"]: Muy bien, amigo. Son 50\n");		

						ACLMessage producto = new ACLMessage( ACLMessage.ACCEPT_PROPOSAL );
						producto.addReceiver( listaDrogadictos[i] );
						producto.setConversationId("meta");
						producto.setReplyWith("producto"+System.currentTimeMillis());
						myAgent.send( producto );
												
						tratarRespuestas = MessageTemplate.and(MessageTemplate.MatchConversationId("meta"),
											   MessageTemplate.MatchInReplyTo(producto.getReplyWith()));
			        	step = 2;
					}
					
				// nos rechaza y hay que buscar a otro comprador
					if ( respuesta.getPerformative() == ACLMessage.REFUSE ) 
					{
						System.out.println("\n[" + getLocalName() +"] Tu te lo pierdes, amigo.\n");		
						step = 3; 
					}
				}
				else 
				{
					block();
				}
				break;				
							
			case 2:		// La decisin del comprador	
				respuesta  = myAgent.receive( tratarRespuestas );
				if (respuesta != null) 
				{
					// Acepta
					if (respuesta.getPerformative() == ACLMessage.INFORM)
					{
							System.out.println( "[" + getLocalName() +"]: [" + listaDrogadictos[i].getLocalName() +"] lo va a gozar.\n");
				        	step = 3;
					}
					else 
					{ //es poli
						System.out.println(  "[" + getLocalName() +"]: Mierda! Un madero...\n");
						System.out.println("---------------------------------------------------------------------------------");
						System.out.println("["+ getLocalName() +"] es detenido por ["+ respuesta.getSender().getLocalName() +"] y los drogadictos que quedan salen corriendo. Se acabo la fiesta.");
						System.out.println("---------------------------------------------------------------------------------\n");
						doDelete();
					}				
				}
				
				else 
				{
					block();
				}
				break;
			
				
			case 3:		// Buscar ms compradores o terminar por hoy
				if ( i < ( listaDrogadictos.length  - 1 ) )
				{
					System.out.println("---------------------------------------------------------------------------------");
					System.out.println("["+getLocalName()+"]: Seguimos con el negocio.");
					System.out.println("---------------------------------------------------------------------------------\n");
				
					doWait(20000);
				
					i++;
					step = 0 ;
				}
				else
					step = 4 ;					
				break;
			}
		}	

		public boolean done() 
		{
			// Terminar por hoy
			if(step == 4) 
			{
				System.out.println("---------------------------------------------------------------------------------");
				System.out.println("["+getLocalName()+"]: Mejor me voy a otra parte.");
				System.out.println("---------------------------------------------------------------------------------\n");
				doDelete();
			}
			return  (step == 4);			
		}		

	}
}
