import java.util.Iterator;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.*;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

public class Cocinero extends Agent{
	
	class ReciveComanda extends SimpleBehaviour{
		MessageTemplate plantilla = null;
		private boolean fin=false;
		public ReciveComanda(){
			AID idCamarero = new AID();
			idCamarero.setLocalName("Camarero");
			MessageTemplate filtroEmisor = MessageTemplate.MatchSender(idCamarero);
			MessageTemplate filtroInform = MessageTemplate.MatchPerformative(ACLMessage.INFORM);
			MessageTemplate filtroConver = MessageTemplate.MatchConversationId("CAMARERO");
			 plantilla = MessageTemplate.and(filtroInform,filtroEmisor);
			
		}
		public void action() {
			ACLMessage mensaje = receive(plantilla);
			if(mensaje!=null){
				AID idCamarero = new AID();
				idCamarero.setLocalName("Camarero");
				ACLMessage mensaje2 = new ACLMessage(ACLMessage.INFORM);
				mensaje2.setSender(getAID());
				mensaje2.addReceiver(idCamarero);
				mensaje2.setContent("OIDO COCINA!");
				System.out.println(getLocalName()+": "+mensaje2.getContent());
				System.out.println(getLocalName()+": (Leyendo la comanda...) "+mensaje.getContent());
				send(mensaje2);
			}
		}
		public boolean done() {
			// TODO Auto-generated method stub
			return fin;
		}
	}
		class HacerComida extends TickerBehaviour{
			 int plato=1;

			public HacerComida(Agent a, long period) {
				super(a, period);
				plato=1;
			}

			private static final long serialVersionUID = 1L;

			@Override
			protected void onTick() {
				ACLMessage platoVa = new ACLMessage(ACLMessage.INFORM);
				platoVa.setSender(getAID());
				AID idCamarero = new AID();
				idCamarero.setLocalName("Camarero");
				platoVa.addReceiver(idCamarero);
				if(plato==1){
				platoVa.setContent("Primero plato listo, camarero!");
				}else if(plato==2){
					platoVa.setContent("Segundo plato listo, camarero!");
				}else if(plato==3){
					platoVa.setContent("El postre está listo, camarero!");
					myAgent.doDelete();
				}
				System.out.println(getLocalName()+": "+platoVa.getContent());
				send(platoVa);
				plato++;
				
			}
			
		}
	protected void setup()
	{
	    addBehaviour(new ReciveComanda());
	    addBehaviour(new HacerComida(this, 20000));
	    
	}

}
	
