package agentes;


import agentes.AgenteAzul.Receptor;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;


public class SanadorRojo extends Agent {

private int vida=3;

public int getVida(){
	return this.vida;
}
private void setVida(int num){
	this.vida=num;
}
public void golpeRecibido(int golpe){
	this.setVida(getVida()-golpe);
}
/*private void sanar(){
	this.setVida(this.getVida()+1);
}*/

////////////////////////////////////////
		/////////////////////////////////////////COMPORTAMIENTO
		/////////////////////////////
protected void setup(){
		    //Aqui es donde se añade el comportamiento.
	addBehaviour(new Accion());

	}
		 
class Accion extends Behaviour 
	{
	public void action()
		{
		String info;  
		 //System.out.println(" SRojo Preparandose para recibir");
		 //Obtiene el primer mensaje de la cola de mensajes
		 ACLMessage mensaje = blockingReceive();
	        System.out.println(getAID().getLocalName()+" recibio un mensaje de "+mensaje.getSender().getLocalName()+": "+mensaje.getContent());
		  if (mensaje!= null)
		  	{
			  info=mensaje.getContent();
		     //System.out.println(getAID().getLocalName() + ": acaba de recibir un mensaje: "+  info);
		    switch (info){
		     case "0"://golpear
		               SanadorRojo.this.golpeRecibido(1);
		               String atacante = mensaje.getSender().getLocalName();
		               myAgent.addBehaviour(new PedirAyuda(atacante));
		               if(SanadorRojo.this.getVida()<1)
		                    doDelete();
		               break;
		     case "1"://sanar
		               //System.out.println(mensaje.getSender().getLocalName() +" pidio ayuda");
		               ACLMessage respuesta = new ACLMessage( ACLMessage.REQUEST );
		               respuesta.setSender(getAID());
		   	        	respuesta.setLanguage("Español");
	                   respuesta.setContent( "1" );
	                   respuesta.clearAllReceiver();
	                   respuesta.addReceiver( mensaje.getSender() );
	                   send(respuesta);    
	                   doDelete();
	                   //System.out.println(respuesta);
	                   break;
		     case "-1":		     	
			     	System.out.println("Un sanador no puede golpear");
	             break;
		     }//swich case
		   }
	
		}//action
		public boolean done(){
			addBehaviour(new Accion());
			return true;}	          
}//clas receptor
private class PedirAyuda extends SimpleBehaviour{
 private String agresor;
	public void setAgresor(String a)
	{
		agresor=a;
	}
	public PedirAyuda(String atacante)
	{
		this.setAgresor(atacante);
	}
	public void action()
    {
		
		System.out.println("Mi nombre es: "+getAID().getLocalName() +" y pido ayuda");
		AID id = new AID();
		
		 id.setLocalName("Dios");//envio mensaje Dios
		 ACLMessage mensaje = new ACLMessage(ACLMessage.REQUEST);
		 mensaje.setSender(getAID());
        mensaje.setLanguage("Español");
        mensaje.clearAllReceiver();
        mensaje.addReceiver(id);
        mensaje.setContent("Rojo");
        send(mensaje);
        ACLMessage mensajeDios = blockingReceive();//espero que dios me conteste
        id = new AID();
        id.setLocalName(mensajeDios.getContent());//envio al que Dios me respondio
		mensajeDios.setSender(getAID());
        mensajeDios.setLanguage("Español");
        mensajeDios.clearAllReceiver();
        mensajeDios.addReceiver(id);
        mensajeDios.setContent(agresor);//ayuda
    //Envia el mensaje a los destinatarios
        send(mensajeDios);
    }
	public boolean done(){
			return true;}
}//PedirAyuda

protected void takeDown() { //aquí se definen las operaciones de limpieza
             System.out.println("Agente "+getAID().getLocalName()+" terminando."); // sólo realiza una despedida
             AID id = new AID();
     		id.setLocalName("dios");
     		ACLMessage mensaje = new ACLMessage(ACLMessage.REQUEST);
     		mensaje.setSender(getAID());
     	    mensaje.setLanguage("Español");
     	    mensaje.clearAllReceiver();
     	    mensaje.addReceiver(id);
     	    mensaje.setContent("-2");//mensaje muerte
     	//Envia el mensaje a los destinatarios
     	    send(mensaje);
         }
}//class



